// locale.js - i18n dictionaries for the Web UI.
// Add more languages by extending window.I18N.
window.I18N = {
  en: {
    "app.title": "USB/IP Web UI",

    "header.connected": "Connected",
    "header.status": "Status",
    "header.wsTitle": "WebSocket",
    "header.statusTitle": "Server status",
    "header.langTitle": "Language",

    "footer.poweredBy": "Powered by chrisoft.io",

    "status.ready": "Ready",
    "status.error": "Error",
    "status.listingExports": "Loading exports…",
    "status.selectingServer": "Selecting server…",
    "status.deletingServer": "Deleting server…",
    "status.addingServer": "Adding server…",
    "status.savingInterval": "Saving interval…",
    "status.updatingAuto": "Updating auto…",
    "status.connecting": "Connecting…",
    "status.disconnecting": "Disconnecting…",
    "status.savingCreds": "Saving credentials…",

    "log.started": "USB/IP Web UI started.",

    "servers.title": "Servers",
    "servers.selected": "Selected",
    "servers.use": "Use",
    "servers.delete": "Delete",
    "servers.newHost": "New server (IP/Host)",
    "servers.newHostPh": "10.0.0.106",
    "servers.tcpPort": "TCP port (optional)",
    "servers.tcpPortPh": "3240",
    "servers.name": "Name (optional)",
    "servers.namePh": "VPS / Home / ...",
    "servers.add": "Add",
    "servers.emptyOption": "— (add a server) —",

    "webif.title": "Web UI",
    "webif.user": "User",
    "webif.pass": "Password",
    "webif.passPh": "(min 4 characters)",
    "webif.saveCreds": "Save credentials",
    "webif.interval": "Auto-connect interval (sec)",
    "webif.saveInterval": "Save interval",

    "devices.title": "Devices",
    "devices.refresh": "Refresh",
    "devices.busid": "BUSID",
    "devices.desc": "Description",
    "devices.vidpid": "VID:PID",
    "devices.auto": "Auto",
    "devices.action": "Action",
    "devices.connect": "Connect",
    "devices.disconnect": "Disconnect",
    "devices.none": "No exported devices.",
    "devices.autoTitle": "Auto-attach by VID:PID ({vp})",
    "devices.unknownVidpidTitle": "Unknown VID:PID",
    "devices.tip": "Tip: the Refresh button queries the remote server. Connect/Disconnect state stays up-to-date using local checks.",

    "devices.loading": "Loading devices…",
    "devices.notConnected": "Not connected to {host}:{port}. Press Refresh.",
    "devices.noServer": "No server selected. Add one in Servers.",

    "ports.inUse": "In use",
    "ports.free": "Free",

    "logs.title": "Logs",

    "log.serversAdded": "[servers] added={host} ({id})",
    "log.serversSelected": "[servers] selected={id}",
    "log.serversDeleted": "[servers] deleted={id}",
    "log.serversError": "[servers][error] {msg}",

    "log.exports": "[exports] {n} device(s) on {host}:{port}",
    "log.exportsError": "[exports][error] {msg}",
    "log.remoteConnectFail": "[server][error] cannot connect to {host}:{port} ({msg})",

    "log.portsError": "[ports][error] {msg}",

    "log.attach": "[attach] {busid} -> {host}:{port}",
    "log.attachAlready": "[attach] already connected: {busid}",
    "log.attachOk": "[attach] attached {busid}",
    "log.attachError": "[attach][error] {msg}",

    "log.detachBusid": "[detach] {busid}",
    "log.detachPort": "[detach] port {port}",
    "log.detachOk": "[detach] ok",
    "log.detachError": "[detach][error] {msg}",

    "log.auto": "[auto] loop enabled (every {sec}s)",
    "log.autoError": "[auto][error] {msg}",

    "log.settingsInterval": "[settings] auto interval = {sec}s",
    "log.settingsError": "[settings][error] {msg}",

    "log.authSaved": "[auth] credentials saved: {user}",
    "log.authDisabled": "[auth] disabled",

    "log.portDropped": "[ports] disconnected (server closed?): {busid}"
  },

  es: {
    "app.title": "USB/IP Web UI",

    "header.connected": "Conectados",
    "header.status": "Estado",
    "header.wsTitle": "WebSocket",
    "header.statusTitle": "Estado del servidor",
    "header.langTitle": "Idioma",

    "footer.poweredBy": "Powered by chrisoft.io",

    "status.ready": "Listo",
    "status.error": "Error",
    "status.listingExports": "Listando exportados…",
    "status.selectingServer": "Seleccionando servidor…",
    "status.deletingServer": "Borrando servidor…",
    "status.addingServer": "Añadiendo servidor…",
    "status.savingInterval": "Guardando intervalo…",
    "status.updatingAuto": "Actualizando auto…",
    "status.connecting": "Conectando…",
    "status.disconnecting": "Desconectando…",
    "status.savingCreds": "Guardando credenciales…",

    "log.started": "USB/IP Web UI iniciado.",

    "servers.title": "Servidores",
    "servers.selected": "Seleccionado",
    "servers.use": "Usar",
    "servers.delete": "Borrar",
    "servers.newHost": "Nuevo servidor (IP/Host)",
    "servers.newHostPh": "10.0.0.106",
    "servers.tcpPort": "TCP port (opcional)",
    "servers.tcpPortPh": "3240",
    "servers.name": "Nombre (opcional)",
    "servers.namePh": "VPS / Casa / ...",
    "servers.add": "Añadir",
    "servers.emptyOption": "— (añade un servidor) —",

    "webif.title": "WebIF",
    "webif.user": "Usuario",
    "webif.pass": "Contraseña",
    "webif.passPh": "(mín 4 caracteres)",
    "webif.saveCreds": "Guardar credenciales",
    "webif.interval": "Intervalo auto-conectar (seg)",
    "webif.saveInterval": "Guardar intervalo",

    "devices.title": "Dispositivos",
    "devices.refresh": "Refrescar",
    "devices.busid": "BUSID",
    "devices.desc": "Descripción",
    "devices.vidpid": "VID:PID",
    "devices.auto": "Auto",
    "devices.action": "Acción",
    "devices.connect": "Conectar",
    "devices.disconnect": "Desconectar",
    "devices.none": "No hay dispositivos exportados.",
    "devices.autoTitle": "Auto-attach por VID:PID ({vp})",
    "devices.unknownVidpidTitle": "VID:PID desconocido",
    "devices.tip": "Tip: el botón Refrescar consulta el servidor remoto. El estado Conectar/Desconectar se mantiene al día con consultas locales.",

    "devices.loading": "Cargando dispositivos…",
    "devices.notConnected": "No conectado a {host}:{port}. Pulsa Refrescar.",
    "devices.noServer": "Ningún servidor seleccionado. Añade uno en Servidores.",

    "ports.inUse": "En uso",
    "ports.free": "Libre",

    "logs.title": "Logs",

    "log.serversAdded": "[servers] added={host} ({id})",
    "log.serversSelected": "[servers] selected={id}",
    "log.serversDeleted": "[servers] deleted={id}",
    "log.serversError": "[servers][error] {msg}",

    "log.exports": "[exports] {n} dispositivo(s) en {host}:{port}",
    "log.exportsError": "[exports][error] {msg}",
    "log.remoteConnectFail": "[servidor][error] no se puede conectar a {host}:{port} ({msg})",

    "log.portsError": "[ports][error] {msg}",

    "log.attach": "[attach] {busid} -> {host}:{port}",
    "log.attachAlready": "[attach] ya estaba conectado: {busid}",
    "log.attachOk": "[attach] conectado {busid}",
    "log.attachError": "[attach][error] {msg}",

    "log.detachBusid": "[detach] {busid}",
    "log.detachPort": "[detach] port {port}",
    "log.detachOk": "[detach] ok",
    "log.detachError": "[detach][error] {msg}",

    "log.auto": "[auto] loop enabled (cada {sec}s)",
    "log.autoError": "[auto][error] {msg}",

    "log.settingsInterval": "[settings] intervalo auto = {sec}s",
    "log.settingsError": "[settings][error] {msg}",

    "log.authSaved": "[auth] credenciales guardadas: {user}",
    "log.authDisabled": "[auth] deshabilitada",

    "log.portDropped": "[ports] desconectado (servidor cerró?): {busid}"
  }
};
